#include "misc.h"

/**
Prints a comma-separated list of the set bit indices in the given mask.
*/
void print_bits(std::ostream &o, unsigned short mask)
{
	bool first=true;
	for(unsigned i=1; i<=9; ++i)
		if(mask&(1<<i))
		{
			if(!first)
				o<<',';
			o<<i;
			first=false;
		}
}

/**
Returns the number of set bits in a mask.
*/
unsigned bitcount(unsigned short mask)
{
	unsigned	count=0;
	for(unsigned i=0; i<32; ++i)
		if(mask&(1<<i)) ++count;
	return count;
}

/**
Returns the index of the first set bit in a mask, or -1 if none were set.
*/
int bitindex(unsigned short mask)
{
	if(!mask) return -1;
	for(unsigned i=0; i<32; ++i)
		if(mask&(1<<i)) return i;
	return -1;
}
