#include <fstream>
#include <iostream>
#include "interface.h"
#include "sudoku.h"

using namespace std;

/**
Main antry point of program.  Processes commandline arguments and handles file
I/O.
*/
int main(int argc, char **argv)
{
	std::string in_fn;
	std::string out_fn;
	bool solve=false;
	bool verbose=false;
	int  o;

	// Process commandline options
	while((o=getopt(argc, argv, "f:so:v"))!=-1)
	{
		switch(o)
		{
		case 'f':
			in_fn=optarg;
			break;
		case 'o':
			out_fn=optarg;
			break;
		case 's':
			solve=true;
			break;
		case 'v':
			verbose=true;
			break;
		}
	}

	Sudoku sudoku;

	if(!in_fn.empty())
	{
		// Load a puzzle from file
		ifstream	in(in_fn.c_str());
		if(in)
		{
			// Use the first line of the file
			string line;
			getline(in, line);
			sudoku.load_from_string(line);
		}
	}
	else if(optind<argc)
		// Load from commandline parameter
		sudoku.load_from_string(argv[optind]);

	sudoku.set_verbose(verbose);

	int result=0;
	if(solve)
	{
		// Solve the puzzle noninteractively
		sudoku.solve();
		result=sudoku.get_solved()?0:1;
	}
	else
	{
		// Run an interactive session
		Interface iface(sudoku);
		iface.run();
	}

	if(!out_fn.empty())
	{
		// Output the solution
		ostream *out=&cout;
		if(out_fn!="-")
			out=new ofstream(out_fn.c_str());

		if(*out)
		{
			// Write a single line consisting of all the cells
			for(unsigned y=0; y<9; ++y)
				for(unsigned x=0; x<9; ++x)
					(*out)<<(char)(sudoku.get_cell(x,y)->get_num()+'0');
			(*out)<<'\n';
		}

		// Delete the output stream if we created our own
		if(out!=&cout)
			delete out;
	}

	return result;
}

